define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/action/place-order',
        'Magento_Checkout/js/action/select-payment-method',
        'Magento_Customer/js/model/customer',
        'Magento_Checkout/js/checkout-data',
        'Magento_Checkout/js/model/payment/additional-validators',
        'mage/url',
        'Magento_Checkout/js/model/quote',
        'Magento_Checkout/js/model/full-screen-loader',
        'Magento_Checkout/js/action/set-payment-information'
    ],
    function ($,
        Component,
        placeOrderAction,
        selectPaymentMethodAction,
        customer,
        checkoutData,
        additionalValidators,
        url,
        quote,
        fullScreenLoader,
        setPaymentInformationAction) {
        'use strict';

        return Component.extend({
            defaults: {
                template: 'Flow_FlowPayment/payment/flowpayment'
            },

            getCode: function () {
                return 'flow_flowpayment';
            },

            getTitle: function () {
                return window.checkoutConfig.pluginConfigFlowPayment.paymentName || 'Flow FlowPayment';
            },
            getLogo: function() {
                var logo = window.checkoutConfig.pluginConfigFlowPayment.logo;
                return logo;
            },
            placeOrder: function (data, event) {
                var self = this;

                if (event) {
                    event.preventDefault();
                }

                this.isPlaceOrderActionAllowed(false);

                this.getPlaceOrderDeferredObject()
                    .fail(
                        function () {
                            self.isPlaceOrderActionAllowed(true);
                        }
                    ).done(
                        function () {

                            var controllerPath = window.checkoutConfig.pluginConfigFlowPayment.createPayment;

                            var urlController = url.build(controllerPath);

                            if (quote.guestEmail) {
                                urlController += '?guestEmail=' + encodeURIComponent(quote.guestEmail);
                            }

                            $.getJSON(urlController, function (result) {
                                window.location.href = result.redirectUrl;
                            });
                        }
                    ).always(
                        function () {
                            self.isPlaceOrderActionAllowed(true);
                            fullScreenLoader.stopLoader();
                        }
                    );

                return false;
            
            },

            getPlaceOrderDeferredObject: function () {
                return $.when(
                    placeOrderAction(this.getData(), this.messageContainer)
                );
            },

        })
    }
);
