<?php
namespace Flow\FlowPayment\Model;

class FlowPayment extends \Magento\Payment\Model\Method\AbstractMethod {

    const CODE = 'flow_flowpayment';
    const PAYMENT_METHOD = 9;
    /**
     * Payment code
     *
     * @var string
     */
    protected $_code = self::CODE;

    protected $_isGateway = true;
    protected $_canCapture = true;
    protected $_canRefund = true;
    protected $_canAuthorize = true;

    /**
     * Availability for currency
     *
     * @param string $currencyCode
     * @return bool
     */
    public function canUseForCurrency($currencyCode) {
        return true;
    }

    public function capture(\Magento\Payment\Model\InfoInterface $payment, $amount) {

        if (!$this->canCapture()) {
            throw new \Magento\Framework\Exception\LocalizedException(__('The capture action is not available.'));
        }
        
        return $this;
    }

    public function authorize(\Magento\Payment\Model\InfoInterface $payment, $amount) {

        if (!$this->canAuthorize()) {
            throw new \Magento\Framework\Exception\LocalizedException(__('The authorize action is not available.'));
        }

        return $this;
    }

    public function refund(\Magento\Payment\Model\InfoInterface $payment, $amount) {

        if (!$this->canRefund()) {
            throw new \Magento\Framework\Exception\LocalizedException(__('The refund action is not available.'));
        }

        return $this;
    }
}
